/*Başlangıç için kaynakları oluşturun:

bash
Copy code
./program init
Üreticiyi başlatın:

bash
Copy code
./program producer
Tüketiciyi başlatın:

bash
Copy code
./program consumer
Program tamamlandıktan sonra kaynakları temizleyin:

bash
Copy code
./program cleanup*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <sys/wait.h>
#include <string.h>
#define BUFFER_SIZE 10 // Tampon boyutu
#define SHM_KEY 1234   // Paylaşılan bellek anahtarı
#define SEM_KEY 5678   // Semafor grubu anahtarı

// Semafor işlemleri
void sem_wait(int sem_id, int sem_num) {
    struct sembuf sb = {sem_num, -1, 0};
    semop(sem_id, &sb, 1);
}

void sem_signal(int sem_id, int sem_num) {
    struct sembuf sb = {sem_num, 1, 0};
    semop(sem_id, &sb, 1);
}

// Üretici fonksiyonu
void producer() {
    int shm_id = shmget(SHM_KEY, (BUFFER_SIZE + 2) * sizeof(int), 0666); // Paylaşılan belleğe bağlan
    int sem_id = semget(SEM_KEY, 2, 0666); // Semafor grubuna bağlan
    int *buffer = shmat(shm_id, NULL, 0); // Paylaşılan belleğe bağlan
    int *in = &buffer[BUFFER_SIZE];       // Üreticinin yazma pozisyonu
    *in = 0;

    for (int i = 0; i < 20; i++) { // 20 öğe üret
        sem_wait(sem_id, 0); // Boş yer var mı? (empty)
        buffer[*in] = rand() % 100; // Rastgele bir sayı üret
        printf("Üretici: %d ekledi (pozisyon: %d)\n", buffer[*in], *in);
        *in = (*in + 1) % BUFFER_SIZE; // Pozisyonu güncelle
        sem_signal(sem_id, 1); // Ürün mevcut (full)
        sleep(1);
    }
    shmdt(buffer); // Paylaşılan bellek bağlantısını kes
}

// Tüketici fonksiyonu
void consumer() {
    int shm_id = shmget(SHM_KEY, (BUFFER_SIZE + 2) * sizeof(int), 0666); // Paylaşılan belleğe bağlan
    int sem_id = semget(SEM_KEY, 2, 0666); // Semafor grubuna bağlan
    int *buffer = shmat(shm_id, NULL, 0); // Paylaşılan belleğe bağlan
    int *out = &buffer[BUFFER_SIZE + 1];  // Tüketicinin okuma pozisyonu
    *out = 0;

    for (int i = 0; i < 20; i++) { // 20 öğe tüket
        sem_wait(sem_id, 1); // Ürün var mı? (full)
        int item = buffer[*out];
        printf("Tüketici: %d tüketti (pozisyon: %d)\n", item, *out);
        *out = (*out + 1) % BUFFER_SIZE; // Pozisyonu güncelle
        sem_signal(sem_id, 0); // Boş yer açıldı (empty)
        sleep(1);
    }
    shmdt(buffer); // Paylaşılan bellek bağlantısını kes
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        printf("Kullanım: %s <producer|consumer>\n", argv[0]);
        return 1;
    }

    if (strcmp(argv[1], "producer") == 0) {
        // Üretici
        producer();
    } else if (strcmp(argv[1], "consumer") == 0) {
        // Tüketici
        consumer();
    } else if (strcmp(argv[1], "init") == 0) {
        // Paylaşılan bellek ve semaforları oluştur
        int shm_id = shmget(SHM_KEY, (BUFFER_SIZE + 2) * sizeof(int), IPC_CREAT | 0666);
        int sem_id = semget(SEM_KEY, 2, IPC_CREAT | 0666);

        // Semafor başlangıç değerlerini ayarla
        semctl(sem_id, 0, SETVAL, BUFFER_SIZE); // empty = BUFFER_SIZE
        semctl(sem_id, 1, SETVAL, 0);          // full = 0

        printf("Paylaşılan bellek ve semaforlar oluşturuldu.\n");
    } else if (strcmp(argv[1], "cleanup") == 0) {
        // Kaynakları temizle
        int shm_id = shmget(SHM_KEY, (BUFFER_SIZE + 2) * sizeof(int), 0666);
        int sem_id = semget(SEM_KEY, 2, 0666);

        shmctl(shm_id, IPC_RMID, NULL); // Paylaşılan belleği sil
        semctl(sem_id, 0, IPC_RMID);   // Semafor grubunu sil

        printf("Paylaşılan bellek ve semaforlar silindi.\n");
    } else {
        printf("Geçersiz seçenek: %s\n", argv[1]);
        return 1;
    }

    return 0;
}
